import os
import scalevi.utils.utils as utils


def dict_to_dfrow(config_dict, results, _results_to_collect):
    config_data = utils.dict_get(
                        config_dict,
                        config_dict['hyper_params_to_iter'])
    _rez = utils.dict_get(
                    results, 
                    ["mean_value", "final_elbo", "time_per_iter"])
    assert(len(_rez)
            == len(_results_to_collect))

    return config_data + _rez

def df_dir_name():
    return  'data/experiments/df/'

def df_file_name(dir_name, uniq_name):
    return  f"{dir_name}{uniq_name}_data_frame.pkl"

def save_df(df, uniq_name, verbose):
    df_dirname = df_dir_name()
    if not os.path.exists(df_dirname):
        os.makedirs(df_dirname)
    df_filename = df_file_name(df_dirname, uniq_name)
    utils.dump_objects(
                    objects=df,
                    fname=df_filename,
                    verbose=verbose)
    if verbose:
        print("DataFrame saved at : {}".format(df_filename,))
